<?php
/**
 * The template for displaying the list of comments and the comment form.
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! post_type_supports( get_post_type(), 'comments' ) ) {
	return;
}

if ( ! have_comments() && ! comments_open() ) {
	return;
}

// Comment Reply Script.
if ( comments_open() && get_option( 'thread_comments' ) ) {
	wp_enqueue_script( 'comment-reply' );
}
?>
<section id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>
		<h2 class="title-comments">
			<?php
			$comments_number = get_comments_number();
			if ( '1' === $comments_number ) {
				printf( esc_html_x( 'One Response', 'comments title', 'hello-elementor' ) );
			} else {
				printf(
					/* translators: %s: Number of comments. */
					esc_html(
						_nx(
							'댓글 %s',
							'댓글 %s',
							$comments_number,
							'comments title',
							'hello-elementor'
						)
					),
					'<span class="num">' . esc_html( number_format_i18n( $comments_number ) ) . '</span>'
				);
			}
			?>
		</h2>

		<?php the_comments_navigation(); ?>

		<ol class="comment-list">
			<?php
			wp_list_comments(
				[
					'style'       => 'ol',
					'short_ping'  => true,
					'avatar_size' => 42,
				]
			);
			?>
		</ol>

		<?php the_comments_navigation(); ?>

	<?php endif; ?>

	<?php
	$comment_send = '등록';
	$comment_reply = '댓글 쓰기';
	$comment_reply_to = '답글 쓰기';
	$comment_author = '닉네임*';
	$comment_email = '이메일';
	$comment_url = '웹사이트';
	$comment_body = '내용을 입력해 주세요*';
	$comment_cookies = ' 다음에 반복 입력할 필요없이 정보를 저장합니다';
	$comment_before = '이메일 주소는 외부에 공개되지 않습니다';
	$comment_abort = '취소';

	//Array
	$comments_args = array(
	    //Define Fields
	    'fields' => array(

		//Author field
		'author, email, url' => '
		<div class="comment-form-group">
			<div class="comment-form-author">
				<input id="author" name="author" type="text" aria-required="true" autocomplete="name" placeholder="' . $comment_author . '"></input>
			</div>

			<div class="comment-form-email">
				<input id="email" name="email" type="email" aria-describedby="email-notes" autocomplete="email" placeholder="' . $comment_email . '"></input>
			</div>

			<div class="comment-form-url">
				<input id="url" name="url" type="url" autocomplete="url" placeholder="' . $comment_url .'"></input>
			</div>
		</div>',
		) ,

	    'logged_in_as' => '' ,

	    'label_submit' => __($comment_send) ,

	    // Change the title of the reply section
	    'title_reply' => __('') ,

	    // Change the title of the reply section
	    'title_reply_to' => __($comment_reply_to) ,

	    'title_reply_before' => '<h2 id="reply-title" class="comment-reply-title">',
		'title_reply_after'  => '</h2>',

	    'cancel_reply_before' => __('<span class="cancel-comment-wrapper">') ,
	    'cancel_reply_after' => __('</span>') ,

	    //Cancel Reply Text
	    'cancel_reply_link' => __($comment_abort) ,

	    // Redefine your own textarea (the comment body).
	    'comment_field' => '<div class="comment-form-comment"><textarea id="comment" name="comment" aria-required="true" placeholder="' . $comment_body . '"></textarea></div>',

	    //Message Before Comment
	    'comment_notes_before' => __('') ,

	    // Remove "Text or HTML to be displayed after the set of comment fields".
	    'id_submit' => __('comment-submit') ,
	);

	comment_form( $comments_args );
	?>
</section>