<?php
/**
 * The template for displaying singular post-types: posts, pages and user-defined custom post types.
 *
 * @package HelloElementor
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

while ( have_posts() ) : the_post(); ?>
<main id="content" <?php post_class( 'site-main' ); ?>>
	<!-- Breadcrumbs -->
	<?php the_breadcrumbs() ?>

	<div class="wrapper-2col">
		<div class="page-content">
			<?php if ( apply_filters( 'hello_elementor_page_title', true ) ) : ?>
				<header class="article-header">
					<h2 class="title-article"><?php the_title(); ?></h2>
					<ul class="article-meta">
						<?php if ( get_the_category() ) : ?>
						<li>
							<span>카테고리</span> <?php the_category( ' · ', '' ); ?>
						</li>
						<?php endif; ?>

						<li>
							<span>작성일</span>
							<span class="value"> <?php echo get_the_date( get_option( 'date_format' ) ); ?></span>
						</li>

						<?php if ( get_comments_number() > 0 ) : ?>
							<li>
								<span>댓글</span>
								<?php comments_popup_link( '0개', '1개', '%개', 'comments-link', '댓글이 비활성화 된 게시물입니다'); ?>
							</li>
						<?php endif; ?>
					</ul>
				</header>
			<?php endif; ?>

			<?php if ( has_post_thumbnail()) : ?>
				<figure class="article-featured-img">
					<?php the_post_thumbnail('full', ['class' => 'img-thumbnail', 'title' => wp_kses_post( get_the_title() )]); ?>
				</figure>
			<?php endif; ?>

			<div class="contents_style">
				<?php the_content(); ?>
			</div>

			<?php
			// wp_link_pages(); // 엘리멘터는 기본 워드프레스 페이지 분할 기능을 제공하지 않음
			?>

			<!-- pagination -->
			<?php if ( 'post' === get_post_type() ) : ?>
				<?php get_template_part( 'custom-parts/pagination', 'prevnext' ); ?>
			<?php endif; ?>

			<!-- related posts -->
			<?php get_template_part( 'custom-parts/related', 'posts' ); ?>

			<?php if ( has_tag() ) : ?>
			<aside class="post-tags">
				<?php the_tags( '<h1 class="title-tag title-format">태그</h1><ul class="tag-list"><li>', '</li><li>', '</li></ul>' ); ?>
			</aside>
			<?php endif; ?>

			<?php comments_template(); ?>
		</div>

		<!-- Sidebar -->
		<?php get_template_part( 'custom-parts/sidebar', 'main' ); ?>
	</div>
</main>

<?php
endwhile;