window.addEventListener("DOMContentLoaded", (event) => {
  jQuery(function($) {

    const header = $('#site-header:not(.elementor-element)');
    if (header.length === 0) return;

    const extraMenu = document.querySelector('#site-header .site-branding');
    let headerExtraScrollDistance = parseFloat(getComputedStyle(extraMenu).height) * (-1);
    const headerScrollDistance = $(header).outerHeight() * (-1);

    // Check mediaQuery
    function matchTo(mobile) {
      if (mobile.matches) {
        $(header).css("top", headerExtraScrollDistance);
      } else {
        $(header).css("top", headerExtraScrollDistance);
        headerExtraScrollDistance = parseFloat(getComputedStyle(extraMenu).height) * (-1);
      }
    }

    const mobileObj = window.matchMedia("(max-width: 991px)")

    matchTo(mobileObj); // Call the match function at run time

    mobileObj.addEventListener("change", function() {
      matchTo(mobileObj);
    });

    // Check scroll
    let prevScrollpos = $(window).scrollTop();

    $(window).on('scroll', function() {
      let currentScrollPos = $(window).scrollTop();

      if (currentScrollPos <= 0) {
        $(header).css("top", mobileObj.matches ? headerExtraScrollDistance : "0");
        $(header).removeClass('shrink-active');

      } else if (prevScrollpos > currentScrollPos) { // When paging up
        $(header).css("top", mobileObj.matches ? '0' : headerExtraScrollDistance);
        $(header).addClass('shrink-active');

      } else { // When paging down (height of your header)
        const headerScrollDistance = $(header).outerHeight() * (-1);
        $(header).css("top", headerScrollDistance);
      }

      prevScrollpos = currentScrollPos;
    });
  });
});