<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$categories = get_the_category();
$category_names = [];
$has_previous = false;
$has_next = false;

if ($categories) {
    foreach ($categories as $category) {
        $category_names[] = $category->name;
    }

    $category_name = implode(' · ', $category_names); // 카테고리 이름을 쉼표로 구분하여 저장
    $category_ids = wp_get_post_categories($post->ID);

    $previous_post = get_posts(array(
        'category__in' => $category_ids,
        'numberposts' => 1,
        'post__not_in' => array($post->ID),
        'orderby' => 'date',
        'order' => 'DESC',
    ));

    $next_post = get_posts(array(
        'category__in' => $category_ids,
        'numberposts' => 1,
        'post__not_in' => array($post->ID),
        'orderby' => 'date',
        'order' => 'ASC',
    ));

    $has_previous = !empty($previous_post);
    $has_next = !empty($next_post);
}
?>

<nav class="post-navigation">
    <?php if ($has_previous || $has_next): ?>
	    <h1 class="title-format">
		    <?php
		    echo ($has_previous || $has_next) ? esc_html( "'$category_name'의 다른 글" ) : esc_html( "다른 글" );
		    ?>
		</h1>
	<?php endif; ?>

    <nav class="nav-wrapper">
    <?php if ($has_previous): ?>
        <div class="prev-post">
            <?php previous_post_link('%link', '<span class="nav-label">이전 글</span>%title', true, '', 'category'); ?>
        </div>
    <?php endif; ?>

    <?php if ($has_next): ?>
        <div class="next-post">
            <?php next_post_link('%link', '<span class="nav-label">다음 글</span>%title', true, '', 'category'); ?>
        </div>
    <?php endif; ?>

    <?php if (!$has_previous && !$has_next): ?>
        <?php if (!$has_previous): ?>
        <div class="prev-post">
            <?php previous_post_link('%link', '<span class="nav-label">이전 글</span>%title'); ?>
        </div>
        <?php endif; ?>
        
        <?php if (!$has_next): ?>
        <div class="next-post">
            <?php next_post_link('%link', '<span class="nav-label">다음 글</span> %title'); ?>
        </div>
        <?php endif; ?>
    <?php endif; ?>
	</nav>
</nav>