<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'hello-elementor','hello-elementor','hello-elementor-theme-style','hello-elementor-header-footer' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css');
// END ENQUEUE PARENT ACTION


// 현재 페이지 경로 표시(Breadcrumbs)
require get_stylesheet_directory() . '/custom-parts/nav-breadcrumbs.php';


/**
 * Jetcraft 초기화 코드
 * https://jetcraft.io/jetcraft-docs/jetcraft-sync-code/
 */
function jetcraft_starterkit_style_sync() {
    wp_enqueue_style( 'jetcraft-style-sync', 'https://cdn.jsdelivr.net/gh/jetcraft-io/jetcraft-sync@main/jetcraft-sync.css', false, '1.0.2' );

    if (!wp_style_is( 'jetcraft-style-sync', 'done' )) {
        wp_enqueue_style( 'jetcraft-style-sync', 'https://fastly.jsdelivr.net/gh/jetcraft-io/jetcraft-sync@main/jetcraft-sync.css', false, '1.0.2' );
    }
}
add_action( 'wp_enqueue_scripts', 'jetcraft_starterkit_style_sync', 100 );


/**
 * Pretendard
 * https://github.com/orioncactus/pretendard
 */
function jetcraft_starterkit_custom_font_pretendard() {
    wp_enqueue_style( 'custom_font_pretendard', 'https://cdn.jsdelivr.net/gh/orioncactus/pretendard@v1.3.9/dist/web/variable/pretendardvariable-dynamic-subset.min.css', false, '1.3.9' );

    if (!wp_style_is( 'custom_font_pretendard', 'done' )) {
        wp_enqueue_style( 'custom_font_pretendard', 'https://fastly.jsdelivr.net/gh/orioncactus/pretendard@v1.3.9/dist/web/variable/pretendardvariable-dynamic-subset.min.css', false, '1.3.9' );
    }
}
add_action( 'wp_enqueue_scripts', 'jetcraft_starterkit_custom_font_pretendard' );


/**
 * Jetcraft 템플릿에서 사용할 글꼴 지정
 */
add_action( 'wp_head', function () { ?>
<style>
    .jetcraft-comp * {
        font-family: "Pretendard Variable", Pretendard, -apple-system, BlinkMacSystemFont, sans-serif;
    }
</style>
<?php });


/**
 * <body> 요소에 클래스 추가
 */
function jetcraft_starterkit_body_class($classes) {
    $classes[] = 'jetcraft-comp';
    $classes[] = 'jetcraft-blog-starter-kit';
    $classes[] = 'jetcraft-color-violet';
    // $classes[] = 'jetcraft-no-radius';

    return $classes;
}
add_filter('body_class', 'jetcraft_starterkit_body_class', 10);


// Sticky 헤더
add_action( 'wp_enqueue_scripts', function() {
    wp_enqueue_script( 'sticky-header', get_stylesheet_directory_uri() . '/assets/js/jquery.stickyheader.js', array( 'jquery' ), null, true );
} );


// 검색바 활성화
function jetcraft_starterkit_add_search_form( $items, $args ) {
    if ($args->theme_location == 'menu-1') {
        $items .= "<li class='site-search'>".get_search_form(false)."</li>";
    }
    return $items;
}
add_filter('wp_nav_menu_items','jetcraft_starterkit_add_search_form', 10, 2);


// 사이드바 설정
add_action('widgets_init', function() {
    register_sidebar( array(
        'name' => 'Sidebar 1',
        'id' => 'sidebar-1',
        'description'   => __( '우측에 위치하는 사이드바입니다' ),
        'before_widget' => '<div class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h1>',
        'after_title' => '</h1>'
    ));
});


// 페이지 타이틀에서 접두사 제거 (ex. Category: / Tag:)
add_filter('get_the_archive_title', function ($title) {
    if (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_tag()) {
        $title = single_tag_title('', false);
    } elseif (is_author()) {
        $title = '<span class="vcard">' . get_the_author() . '</span>';
    } elseif (is_tax()) { //for custom post types
        $title = sprintf(__('%1$s'), single_term_title('', false));
    } elseif (is_post_type_archive()) {
        $title = post_type_archive_title('', false);
    }
    return $title;
});


// 댓글 작성 시 이름 필드 필수
add_filter('preprocess_comment', function($fields) {
    if ($fields['comment_author'] == '') wp_die('Error: 이름은 필수항목입니다.');
    return $fields;
});


// 닉네임과 내용 없이 댓글 제출을 방지
add_action( 'wp_enqueue_scripts', function() {
    wp_enqueue_script( 'prevent-blank-comments', get_stylesheet_directory_uri() . '/assets/js/prevent-blank-comment.js', array(), null, true );
} );


// 답글 달기 버튼 이름 변경
add_filter('comment_reply_link_args', function($args) {
    $args['reply_text'] = __('답글');
    return $args;
});


// 댓글 작성일을 알기 쉬운 형식으로 변경
add_filter('get_comment_date', function($date, $d, $comment){
    return sprintf( _x( '%s 전', '%s = human-readable time difference', 'your-text-domain' ), human_time_diff( get_comment_time( 'U' ), current_time( 'timestamp' ) ) );
}, 10, 3);
