(function() {
    document.addEventListener('DOMContentLoaded', function() {
        const commentField = document.getElementById('comment');
        const authorField = document.getElementById('author');
        const submitButton = document.getElementById('comment-submit');
        const isLoggedIn = document.body.classList.contains('logged-in');

        if (!submitButton) return;

        toggleSubmitButton();

        // 입력 필드에서 입력 내용이 변경될 때마다 실행
        commentField.addEventListener('input', toggleSubmitButton);
        if (authorField) {
            authorField.addEventListener('input', toggleSubmitButton);
        }

        function toggleSubmitButton() {
            if (isLoggedIn) {
                submitButton.disabled = commentField.value.trim() === '';
            } else {
                submitButton.disabled = commentField.value.trim() === '' || authorField.value.trim() === '';
            }
        }
    });

})();