<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<?php
while ( have_posts() ) {
	the_post();
	$categories = get_the_category();
	$post_date = get_the_date();
	$post_link = get_permalink();
?>
	<article class="article">
	    <?php if ( has_post_thumbnail()) : ?>
	    <a href="<?php the_permalink(); ?>" class="article-link" aria-label="<?php the_title(); ?>">
	        <p class="thumbnail" style="background-image: url(<?php the_post_thumbnail_url(); ?>)">
	            <?php the_post_thumbnail(
	            	'full', 
	            	[
	            		'class' => 'img-thumbnail', 
	            		'title' => wp_kses_post( get_the_title() ),
	            		'alt' => '썸네일 이미지'
	            	]
	            ); ?>
	        </p>
	    </a>
	    <?php endif; ?>

	    <div class="article-content">
	        <a href="<?php the_permalink(); ?>" class="link-article">
	            <strong class="title"><?php the_title(); ?></strong>
	            <?php echo '<p class="summary">' . get_the_excerpt() . '</p>' ?>
	        </a>
	        <div class="box-meta">
	            <?php 
	            if ($categories) { 
	            	foreach($categories as $category) { 
	            		echo '<a class="link-category" href="' . get_category_link($category->term_id) . '">' . esc_html($category->cat_name) . '</a> <span class="divider">·</span> '; 
	            	}
	            }
				?>
	            <span class="date"><?php echo esc_html($post_date); ?></span>
	        </div>
	    </div>
	</article>
<?php } ?>