<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

// 빵조각 네비게이션
function the_breadcrumbs() {
    global $post;
    echo '<ul id="breadcrumbs">';
    if (!is_home()) {
        echo '<li><a href="';
        echo esc_url(get_option('home'));
        echo '">';
        echo '처음';
        echo '</a></li><li class="separator">/</li>';
        if (is_category() || is_single()) {
            $categories = get_the_category();
            if (!empty($categories)) {
                $first_category = $categories[0]; // 첫 번째 카테고리 선택
                echo '<li><a href="' . esc_url(get_category_link($first_category->term_id)) . '">' . esc_html($first_category->cat_name) . '</a></li>';
                if (is_single()) {
                    echo '<li class="separator">/</li><li>' . esc_html(get_the_title()) . '</li>';
                }
            }
        } elseif (is_page()) {
            if ($post->post_parent) {
                $anc = get_post_ancestors($post->ID);
                $title = get_the_title();
                foreach ($anc as $ancestor) {
                    $output = '<li><a href="' . esc_url(get_permalink($ancestor)) . '" title="' . esc_attr(get_the_title($ancestor)) . '">' . esc_html(get_the_title($ancestor)) . '</a></li> <li class="separator">/</li>';
                }
                echo $output;
                echo '<span title="' . esc_attr($title) . '"> ' . esc_html($title) . '</span>';
            } else {
                echo '<li><span> ' . esc_html(get_the_title()) . '</span></li>';
            }
        }
    } elseif (is_tag()) {
        single_tag_title();
    } elseif (is_day()) {
        echo "<li>Archive for " . esc_html(get_the_date('F jS, Y')) . "</li>";
    } elseif (is_month()) {
        echo "<li>Archive for " . esc_html(get_the_date('F, Y')) . "</li>";
    } elseif (is_year()) {
        echo "<li>Archive for " . esc_html(get_the_date('Y')) . "</li>";
    } elseif (is_author()) {
        echo "<li>사용자</li>";
    } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {
        echo "<li>페이지 " . esc_html($_GET['paged']) . "</li>";
    } elseif (is_search()) {
        echo "<li>검색 결과 : </li>";
    }
    echo '</ul>';
}
?>