<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$categories = get_the_category();
$category_names = [];
$has_previous = false;
$has_next = false;

if ($categories) {
    foreach ($categories as $category) {
        $category_names[] = $category->name;
    }

    $category_name = implode(' · ', $category_names); // 카테고리 이름을 쉼표로 구분하여 저장
    $category_ids = wp_get_post_categories($post->ID);

    $related = get_posts( array( 
	    'category__in' => $category_ids, 
	    'numberposts' => 5, 
	    'post__not_in' => array($post->ID) 
	) );
}

// 관련 글이 있는 경우에만 출력
if ( $related ) : ?>
    <section class="post-navigation-related">
        <h1 class="title-format"><span><?php echo esc_html( $category_name ); ?></span> 카테고리의 더 많은 글</h1>
        <table>
            <tbody>
                <?php foreach( $related as $post ) : 
                    setup_postdata($post); ?>
                    <tr>
                        <th>
                            <a href="<?php the_permalink(); ?>" rel="bookmark">
                                <?php echo esc_html(get_the_title()); ?>
                            </a>
                            <span class="related-comments"><?php echo esc_html(get_comments_number()); ?></span>
                        </th>
                        <td><?php echo esc_html(get_the_date()); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php wp_reset_postdata(); ?>
    </section>
<?php endif; ?>