<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>
<main id="content" class="site-main">

	<!-- Breadcrumbs -->
	<?php the_breadcrumbs(); ?>

	<div class="wrapper-2col">
		<div class="page-content">
			
			<div class="loop-posts">
				<h2 class="page-total-number"><b><?php echo esc_html__( 'The page can&rsquo;t be found.', 'hello-elementor' ); ?></b></h2>

				<?php if ( have_posts() ) : ?>
					<!-- main loop -->
					<?php get_template_part( 'custom-parts/loop', 'posts' ); ?>
				<?php else : ?>
					<p class="no-results-message"><?php echo esc_html__( 'It looks like nothing was found at this location.', 'hello-elementor' ); ?></p>
					<a href="/" class="btn-theme-default">처음 페이지</a>
				<?php endif; ?>
			</div>
		</div>

		<!-- Sidebar -->
		<?php get_template_part( 'custom-parts/sidebar', 'main' ); ?>
	</div>
</main>