<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$search_query = get_search_query();
$args = array(
    's' => $search_query,
    'posts_per_page' => -1, // 모든 결과 가져오기
);

$search_results = get_posts( $args );
$total_posts = count( $search_results ); // 총 포스트 수
?>
<main id="content" class="site-main">

	<!-- Breadcrumbs -->
	<?php the_breadcrumbs(); ?>

	<div class="wrapper-2col">
		<div class="page-content">
			
			<div class="loop-posts">
				<h2 class="page-total-number"><b>검색결과 </b><span><?php echo $total_posts; ?></span></h2>

				<?php if ( have_posts() ) : ?>
					<!-- main loop -->
					<?php get_template_part( 'custom-parts/loop', 'posts' ); ?>
				<?php else : ?>
					<p class="no-results-message"><?php echo esc_html__( 'It seems we can\'t find what you\'re looking for.', 'hello-elementor' ); ?></p>
					<a href="javascript:history.back()" class="btn-theme-default">이전 페이지</a>
				<?php endif; ?>
			</div>

			<!-- pagination -->
			<?php get_template_part( 'custom-parts/pagination', 'main' ); ?>
		</div>

		<!-- Sidebar -->
		<?php get_template_part( 'custom-parts/sidebar', 'main' ); ?>
	</div>
</main>